<?php
  function remote_file_size ($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $data = curl_exec($ch);
    curl_close($ch);
    if ($data === false) {
      return 0;
    }

    $contentLength = 0;
    if (preg_match('/Content-Length: (\d+)/', $data, $matches)) {
      $contentLength = (int)$matches[1];
    }

    return $contentLength;
  }

  function get_http_status ($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $data = curl_exec($ch);
    curl_close($ch);
    if ($data === false) {
      return "0";
    }

    $return = "0";
    if (preg_match('/HTTP\/1.1 (\d+)/', $data, $matches)) {
      $return = (int)$matches[1];
    }

    return $return;
  }

  function captcha ($i) {
    $root = $_SERVER['DOCUMENT_ROOT'];
    $len = strlen($root);
    $fix = $len * ord(substr($root,-1,1)) * ord(substr($root,-2,1));

    $time = (int)(time()/1000) - (int)$i;
    return substr((string)(sin($fix*$time)),-5,5);
  }
  
?>
