﻿<!-- ======================================================================= -->
<!--                                                                         -->
<!--             XSLT - Transform Toolbox-XML to Microsoft WML               -->
<!--                                                                         -->
<!-- Copyright (C) 2006 Jan Krohn                                            -->
<!--                                                                         -->
<!-- This program is free software; you can redistribute it and/or           -->
<!-- modify it under the terms of the GNU General Public License as          -->
<!-- published by the Free Software Foundation; version 2 of the             -->
<!-- License.                                                                -->
<!--                                                                         -->
<!-- This program is distributed in the hope that it will be useful,         -->
<!-- but WITHOUT ANY WARRANTY; without even the implied warranty of          -->
<!-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           -->
<!-- GNU General Public License for more details.                            -->
<!--                                                                         -->
<!-- You should have received a copy of the GNU General Public License       -->
<!-- along with this program; if not, write to the Free Software             -->
<!-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,              -->
<!-- MA 02110-1301 USA.                                                      -->
<!--                                                                         -->
<!-- Contact: Jan Krohn, Haidstraße 54, 63741 Aschaffenburg, Germany         -->
<!--          webmaster@vic-fontaine.com; phone: 0049-6021-1304099-0         -->
<!--                                                                         -->
<!-- ======================================================================= -->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output encoding="utf-8" indent="yes" method="xml" standalone="yes" version="1.0"/>

  <!-- ===================================================================== -->
  <!--                      Input parameters come here                       -->
  <!-- ===================================================================== -->

  <xsl:param name="TITLE"/>
  <xsl:param name="SUBTITLE"/>
  <xsl:param name="AUTHOR"/>
  <xsl:param name="LANGUAGE"/>
  <xsl:param name="UTF8_FONT"/>

  <xsl:strip-space elements="*"/>

  <xsl:template match="/">

    <xsl:processing-instruction name="mso-application">
      <xsl:text>progid="Word.Document"</xsl:text>
    </xsl:processing-instruction>

    <w:wordDocument xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml">
      <xsl:attribute name="xml:space">
        <xsl:value-of select="'preserve'"/>
      </xsl:attribute>
      <o:DocumentProperties>
        <o:Title>
          <xsl:value-of select="concat($TITLE,' ',$SUBTITLE)"/>
        </o:Title>
        <o:Author>
          <xsl:value-of select="$AUTHOR"/>
        </o:Author>
        <o:Version>11.8106</o:Version>
      </o:DocumentProperties>

      <!-- ================================================================= -->
      <!--                      Default font definitions                     -->
      <!-- ================================================================= -->

      <w:fonts>
        <xsl:element name="w:defaultFonts">
          <xsl:attribute name="w:ascii">
            <xsl:value-of select="$UTF8_FONT"/>
          </xsl:attribute>
          <xsl:attribute name="w:cs">
            <xsl:value-of select="$UTF8_FONT"/>
          </xsl:attribute>
          <xsl:attribute name="w:fareast">
            <xsl:value-of select="$UTF8_FONT"/>
          </xsl:attribute>
          <xsl:attribute name="w:h-ansi">
            <xsl:value-of select="$UTF8_FONT"/>
          </xsl:attribute>
        </xsl:element>
      </w:fonts>

      <!-- ================================================================= -->
      <!--                      Styles definitions                           -->
      <!-- ================================================================= -->

      <w:styles>

        <w:style w:default="on" w:styleId="Standard" w:type="paragraph">
          <w:name w:val="Standard"/>
          <w:rPr>
            <w:sz w:val="24"/>
          </w:rPr>
        </w:style>

        <w:style w:styleId="OriginalWord" w:type="character">
          <w:basedOn w:val="Standard"/>
          <w:name w:val="OriginalWord"/>
          <w:rPr>
            <w:b/>
            <w:u w:val="single"/>
          </w:rPr>
        </w:style>

        <w:style w:styleId="TranslatedWord" w:type="character">
          <w:basedOn w:val="Standard"/>
          <w:name w:val="TranslatedWord"/>
          <w:rPr>
            <w:i/>
          </w:rPr>
        </w:style>

        <w:style w:default="off" w:styleId="BookTitle" w:type="paragraph">
          <w:name w:val="BookTitle"/>
          <w:pPr>
            <w:jc w:val="center"/>
            <w:spacing w:before="2000"/>
          </w:pPr>
          <w:rPr>
            <w:sz w:val="96"/>
          </w:rPr>
        </w:style>

        <w:style w:default="off" w:styleId="BookSubtitle" w:type="paragraph">
          <w:name w:val="BookSubtitle"/>
          <w:pPr>
            <w:jc w:val="center"/>
          </w:pPr>
          <w:rPr>
            <w:i/>
            <w:sz w:val="56"/>
          </w:rPr>
        </w:style>

        <w:style w:default="off" w:styleId="EvenHeader" w:type="paragraph">
          <w:basedOn w:val="Standard"/>
          <w:name w:val="EvenHeader"/>
          <w:pPr>
            <w:jc w:val="left"/>
          </w:pPr>
          <w:rPr>
            <w:i/>
          </w:rPr>
        </w:style>

        <w:style w:default="off" w:styleId="OddHeader" w:type="paragraph">
          <w:basedOn w:val="Standard"/>
          <w:name w:val="OddHeader"/>
          <w:pPr>
            <w:jc w:val="right"/>
          </w:pPr>
          <w:rPr>
            <w:i/>
          </w:rPr>
        </w:style>
      </w:styles>

      <w:docPr>
        <w:evenAndOddHeaders/>
      </w:docPr>

      <w:body>

        <!-- =============================================================== -->
        <!--                      Title page is created here                 -->
        <!-- =============================================================== -->

        <w:p>
          <w:pPr>
            <w:pStyle w:val="BookTitle"/>
          </w:pPr>
          <w:r>
            <w:t>
              <xsl:value-of select="$TITLE"/>
            </w:t>
          </w:r>
        </w:p>
        <w:p>
          <w:pPr>
            <w:pStyle w:val="BookSubtitle"/>
          </w:pPr>
          <w:r>
            <w:t>
              <xsl:value-of select="$SUBTITLE"/>
            </w:t>
          </w:r>
        </w:p>

        <!-- =============================================================== -->
        <!--               Title Page properties definitions                 -->
        <!-- =============================================================== -->

        <w:p>
          <w:pPr>
            <w:sectPr>
              <w:pgSz w:h="16838" w:w="11906"/>
              <w:pgMar w:bottom="1134" w:footer="708" w:gutter="0" w:header="708" w:left="1417" w:right="1417" w:top="1417"/>
              <w:cols w:space="708"/>
              <w:docGrid w:line-pitch="360"/>
            </w:sectPr>
          </w:pPr>
        </w:p>

        <!-- =============================================================== -->
        <!--              Actual transformation is triggered here            -->
        <!-- =============================================================== -->

        <xsl:apply-templates select="//lxGroup"/>

        <!-- =============================================================== -->
        <!--                 Page properties definitions                     -->
        <!-- =============================================================== -->

        <w:sectPr>
          <w:pgSz w:h="16838" w:w="11906"/>
          <w:pgMar w:bottom="1134" w:footer="708" w:gutter="0" w:header="708" w:left="1417" w:right="1417" w:top="1417"/>
          <w:cols w:num="2" w:space="708"/>
          <w:docGrid w:line-pitch="360"/>

          <!-- ============================================================= -->
          <!--                     Header definitions                        -->
          <!-- ============================================================= -->

          <w:hdr w:type="even">
            <w:p>
              <w:pPr>
                <w:pStyle w:val="EvenHeader"/>
              </w:pPr>
              <w:fldSimple w:instr=" STYLEREF  OriginalWord  \* MERGEFORMAT "/>
            </w:p>
          </w:hdr>
          <w:hdr w:type="odd">
            <w:p>
              <w:pPr>
                <w:pStyle w:val="OddHeader"/>
              </w:pPr>
              <w:fldSimple w:instr=" STYLEREF  OriginalWord \l  \* MERGEFORMAT "/>
            </w:p>
          </w:hdr>
        </w:sectPr>
      </w:body>
    </w:wordDocument>
  </xsl:template>

  <!-- ===================================================================== -->
  <!--               Template for a single dictionary entry                  -->
  <!-- ===================================================================== -->

  <xsl:template xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" match="lxGroup">
    <xsl:if test="$LANGUAGE='EN' and lx!='' and ge!=''">
      <w:p>
        <w:r>
          <w:rPr>
            <w:rStyle w:val="OriginalWord"/>
          </w:rPr>
          <w:t>
            <xsl:value-of select="lx"/>
          </w:t>
        </w:r>
        <w:r>
          <w:t>
            <xsl:value-of select="', '"/>
          </w:t>
        </w:r>
        <w:r>
          <w:rPr>
            <w:rStyle w:val="TranslatedWord"/>
          </w:rPr>
          <w:t>
            <xsl:value-of select="ge"/>
          </w:t>
        </w:r>
        <xsl:if test="xv!='' and xe!=''">
          <w:r>
            <w:t>
              <xsl:value-of select="concat(' (Ex. ',xv,' - ',xe,')')"/>
            </w:t>
          </w:r>
        </xsl:if>
      </w:p>
    </xsl:if>

    <xsl:if test="$LANGUAGE='FR' and lx!='' and gf!=''">
      <w:p>
        <w:r>
          <w:rPr>
            <w:rStyle w:val="OriginalWord"/>
          </w:rPr>
          <w:t>
            <xsl:value-of select="concat(lx,',')"/>
          </w:t>
        </w:r>
        <w:r>
          <w:rPr>
            <w:rStyle w:val="TranslatedWord"/>
          </w:rPr>
          <w:t>
            <xsl:value-of select="concat(' ',gf)"/>
          </w:t>
        </w:r>
        <xsl:if test="xv!='' and xf!=''">
          <w:r>
            <w:t>
              <xsl:value-of select="concat(' (Ex. ',xv,' - ',xf,')')"/>
            </w:t>
          </w:r>
        </xsl:if>
      </w:p>
    </xsl:if>
  </xsl:template>

</xsl:transform>