﻿Public Class Form1

    Private Sub bnFileSource_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bnFileSource.Click
        ofSource.ShowDialog()
    End Sub

    Private Sub ofSource_FileOk(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles ofSource.FileOk
        tbSource.Text = ofSource.FileName
    End Sub

    Private Sub tbSource_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbSource.TextChanged
        Try
            wbSource.Navigate(tbSource.Text)
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub bnFileDestination_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bnFileDestination.Click
        sfDestination.ShowDialog()
    End Sub

    Private Sub sfDestination_FileOk(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles sfDestination.FileOk
        tbDestination.Text = sfDestination.FileName
    End Sub

    Private Sub bnStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bnStart.Click
        Try

            'Instantiate a new XPathDocument object and load the source XML. 
            Dim xmlDoc As New System.Xml.XmlTextReader(tbSource.Text)

            'Instantiate a new XslTransform object and load the style sheet. 
            Dim xslt As New System.Xml.Xsl.XslCompiledTransform()
            xslt.Load("make_wml.xsl")

            'Instantiate an XsltArgumentList object. 
            Dim xsltArgList As New System.Xml.Xsl.XsltArgumentList()

            'The following lines set the valuess for the parameters
            xsltArgList.AddParam("TITLE", "", tbTitle.Text)
            xsltArgList.AddParam("SUBTITLE", "", tbSubtitle.Text)
            xsltArgList.AddParam("AUTHOR", "", tbAuthor.Text)
            xsltArgList.AddParam("LANGUAGE", "", tbLanguage.Text)
            xsltArgList.AddParam("UTF8_FONT", "", tbFont.Text)

            'Execute the transformation and generate the output to the Response object's
            'output stream.
            Dim xmlWriter As System.Xml.XmlTextWriter
            xmlWriter = New System.Xml.XmlTextWriter(tbDestination.Text, System.Text.Encoding.UTF8)
            xslt.Transform(xmlDoc, xsltArgList, xmlWriter)
            xmlWriter.Close()

            wbDestination.Navigate(tbDestination.Text)

            'Exception handling code.
        Catch ex As Exception
            MsgBox(ex.Message)

        End Try

    End Sub

End Class
